define([
    'underscore',
    'modules/page/popup/warning-popup-view',
    'text!modules/form/leave-confirmation/leave-confirmation.html',
], function (_, WarningPopupView, template) {
    'use strict';


    return WarningPopupView.extend({
        template: _.template(template),
        id: 'leave-confirmation',
        events: {
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'continue',
            'click .warning-return-btn': 'closePopup',
        },
        initialize: function(options) {
            this._initializeElAfterClose(options);
        },

        continue: function() {
            $('#' + this.id).popup('close');
            this.options.continue();
        },
    });
});
